/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.options;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.Prefs;
import com.megacrit.cardcrawl.helpers.SaveHelper;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.screens.DisplayOption;
import com.megacrit.cardcrawl.screens.options.OptionsPanel;
import com.megacrit.cardcrawl.vfx.RestartForChangesEffect;
import java.util.ArrayList;
import java.util.Collections;

public class Dropdown {
    private DropdownType type;
    private int index;
    private static int TMP_WIDTH = Settings.WIDTH;
    private static int TMP_HEIGHT = Settings.HEIGHT;
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("LanguageDropdown");
    public static final String[] TEXT = Dropdown.uiStrings.TEXT;
    public Hitbox hb;
    private float x;
    private float y;
    private String label;
    private String currentLanguage;
    private ArrayList<Integer> frameratePresets = new ArrayList();

    public Dropdown(float x, float y, DropdownType type) {
        this.type = type;
        this.x = x;
        this.y = Settings.OPTION_Y + y * Settings.scale;
        this.hb = new Hitbox(200.0f * Settings.scale, 38.0f * Settings.scale);
        this.hb.move(x, this.y);
        this.populateList();
        switch (type) {
            case RESOLUTION: {
                this.label = Integer.toString(TMP_WIDTH) + " x " + Integer.toString(TMP_HEIGHT);
                break;
            }
            case FPS: {
                this.label = Integer.toString(Settings.MAX_FPS);
                break;
            }
            case LANGUAGE: {
                Prefs gamePref = SaveHelper.getPrefs("STSGameplaySettings");
                this.label = gamePref.getString("LANGUAGE", "English");
                this.currentLanguage = gamePref.getString("LANGUAGE", "English");
                break;
            }
        }
    }

    public void update() {
        this.hb.update();
        if (this.hb.hovered && InputHelper.justClickedLeft) {
            this.clickDropdown();
        }
    }

    private void clickDropdown() {
        ++this.index;
        switch (this.type) {
            case RESOLUTION: {
                this.updateResolution();
                break;
            }
            case FPS: {
                this.updateFps();
                break;
            }
            case LANGUAGE: {
                this.updateLanguage();
                break;
            }
        }
    }

    private void updateResolution() {
        if (CardCrawlGame.mode == CardCrawlGame.GameMode.CHAR_SELECT) {
            CardCrawlGame.mainMenuScreen.optionPanel.effects.clear();
            CardCrawlGame.mainMenuScreen.optionPanel.effects.add(new RestartForChangesEffect());
            if (CardCrawlGame.mainMenuScreen.optionPanel.fsToggle.enabled) {
                CardCrawlGame.mainMenuScreen.optionPanel.fsToggle.toggle();
            }
            if (CardCrawlGame.mainMenuScreen.optionPanel.wfsToggle.enabled) {
                CardCrawlGame.mainMenuScreen.optionPanel.wfsToggle.toggle();
            }
        } else {
            AbstractDungeon.topLevelEffects.add(new RestartForChangesEffect());
            if (AbstractDungeon.settingsScreen.panel.fsToggle.enabled) {
                AbstractDungeon.settingsScreen.panel.fsToggle.toggle();
            }
            if (AbstractDungeon.settingsScreen.panel.wfsToggle.enabled) {
                AbstractDungeon.settingsScreen.panel.wfsToggle.toggle();
            }
        }
        if (this.index > Settings.displayOptions.size() - 1) {
            this.index = 0;
        }
        TMP_WIDTH = Settings.displayOptions.get((int)this.index).width;
        TMP_HEIGHT = Settings.displayOptions.get((int)this.index).height;
        OptionsPanel.writeDisplayConfigFile(TMP_WIDTH, TMP_HEIGHT, Settings.MAX_FPS, Settings.IS_FULLSCREEN, Settings.IS_W_FULLSCREEN, Settings.IS_V_SYNC);
        Settings.SAVED_WIDTH = TMP_WIDTH;
        Settings.SAVED_HEIGHT = TMP_HEIGHT;
        this.label = Integer.toString(TMP_WIDTH) + " x " + Integer.toString(TMP_HEIGHT);
    }

    private void updateFps() {
        boolean found = false;
        for (int i = 0; i < this.frameratePresets.size(); ++i) {
            if (Settings.MAX_FPS != this.frameratePresets.get(i)) continue;
            found = true;
            if (i != this.frameratePresets.size() - 1) {
                Settings.MAX_FPS = this.frameratePresets.get(i + 1);
                break;
            }
            Settings.MAX_FPS = this.frameratePresets.get(0);
            break;
        }
        if (!found) {
            Settings.MAX_FPS = 60;
        }
        this.label = Integer.toString(Settings.MAX_FPS);
        OptionsPanel.writeDisplayConfigFile(Settings.SAVED_WIDTH, Settings.SAVED_HEIGHT, Settings.MAX_FPS, Settings.IS_FULLSCREEN, Settings.IS_W_FULLSCREEN, Settings.IS_V_SYNC);
        if (CardCrawlGame.mode == CardCrawlGame.GameMode.CHAR_SELECT) {
            CardCrawlGame.mainMenuScreen.optionPanel.effects.clear();
            CardCrawlGame.mainMenuScreen.optionPanel.effects.add(new RestartForChangesEffect());
        } else {
            AbstractDungeon.topLevelEffects.add(new RestartForChangesEffect());
        }
    }

    private void updateLanguage() {
        if (this.currentLanguage.equals("English")) {
            this.currentLanguage = "Chinese (Simplified)";
            this.label = TEXT[1];
        } else if (this.currentLanguage.equals("Chinese (Simplified)")) {
            this.currentLanguage = "Chinese (Traditional)";
            this.label = TEXT[2];
        } else if (this.currentLanguage.equals("Chinese (Traditional)")) {
            this.currentLanguage = "French";
            this.label = TEXT[4];
        } else if (this.currentLanguage.equals("French")) {
            this.currentLanguage = "German";
            this.label = TEXT[5];
        } else if (this.currentLanguage.equals("German")) {
            this.currentLanguage = "Japanese";
            this.label = TEXT[7];
        } else if (this.currentLanguage.equals("Japanese")) {
            this.currentLanguage = "Korean";
            this.label = TEXT[8];
        } else if (this.currentLanguage.equals("Korean")) {
            this.currentLanguage = "Russian";
            this.label = TEXT[10];
        } else if (this.currentLanguage.equals("Russian")) {
            this.currentLanguage = "English";
            this.label = TEXT[3];
        } else if (this.currentLanguage.equals("Hebrew")) {
            this.currentLanguage = "English";
            this.label = TEXT[3];
        } else {
            this.currentLanguage = "English";
            this.label = TEXT[3];
        }
        Settings.setLanguage(this.currentLanguage, false);
        CardCrawlGame.mainMenuScreen.optionPanel.effects.clear();
        CardCrawlGame.mainMenuScreen.optionPanel.effects.add(new RestartForChangesEffect());
    }

    private void populateList() {
        switch (this.type) {
            case LANGUAGE: {
                break;
            }
            case FPS: {
                this.frameratePresets.clear();
                this.frameratePresets.add(24);
                this.frameratePresets.add(30);
                this.frameratePresets.add(60);
                this.frameratePresets.add(120);
                this.frameratePresets.add(240);
                break;
            }
            case RESOLUTION: {
                if (Settings.displayOptions == null) {
                    Settings.displayOptions = new ArrayList();
                    ArrayList<DisplayOption> availableResos = new ArrayList<DisplayOption>();
                    availableResos.add(new DisplayOption(1024, 576));
                    availableResos.add(new DisplayOption(1280, 720));
                    availableResos.add(new DisplayOption(1366, 768));
                    availableResos.add(new DisplayOption(1536, 864));
                    availableResos.add(new DisplayOption(1600, 900));
                    availableResos.add(new DisplayOption(1920, 1080));
                    availableResos.add(new DisplayOption(2560, 1440));
                    availableResos.add(new DisplayOption(3840, 2160));
                    availableResos.add(new DisplayOption(1024, 640));
                    availableResos.add(new DisplayOption(1280, 800));
                    availableResos.add(new DisplayOption(1680, 1050));
                    availableResos.add(new DisplayOption(1920, 1200));
                    availableResos.add(new DisplayOption(2560, 1600));
                    Graphics.DisplayMode[] modes = Gdx.graphics.getDisplayModes(Gdx.graphics.getPrimaryMonitor());
                    ArrayList<DisplayOption> monitorResos = new ArrayList<DisplayOption>();
                    for (Graphics.DisplayMode m : modes) {
                        DisplayOption o = new DisplayOption(m.width, m.height);
                        if (monitorResos.contains(o)) continue;
                        monitorResos.add(o);
                    }
                    for (DisplayOption o : availableResos) {
                        if (o.width > Gdx.graphics.getDisplayMode().width || o.height > Gdx.graphics.getDisplayMode().height) continue;
                        Settings.displayOptions.add(o);
                    }
                    Collections.sort(Settings.displayOptions);
                    for (int i = 0; i < Settings.displayOptions.size(); ++i) {
                        if (Settings.WIDTH != Settings.displayOptions.get((int)i).width || Settings.HEIGHT != Settings.displayOptions.get((int)i).height) continue;
                        Settings.displayIndex = i;
                        break;
                    }
                }
                this.index = Settings.displayIndex;
                break;
            }
        }
    }

    public void render(SpriteBatch sb) {
        switch (this.type) {
            case RESOLUTION: {
                if (this.hb.hovered) {
                    FontHelper.renderFontCentered(sb, FontHelper.tipBodyFont, this.label, this.x, this.y, Settings.GOLD_COLOR);
                    break;
                }
                FontHelper.renderFontCentered(sb, FontHelper.tipBodyFont, this.label, this.x, this.y, Settings.BLUE_TEXT_COLOR);
                break;
            }
            case FPS: {
                if (this.hb.hovered) {
                    FontHelper.renderFontCentered(sb, FontHelper.tipBodyFont, this.label, this.x, this.y, Settings.GOLD_COLOR);
                    break;
                }
                FontHelper.renderFontCentered(sb, FontHelper.tipBodyFont, this.label, this.x, this.y, Settings.BLUE_TEXT_COLOR);
                break;
            }
            case LANGUAGE: {
                if (Settings.language != Settings.GameLanguage.ENGLISH) {
                    if (this.hb.hovered) {
                        FontHelper.renderFontCentered(sb, FontHelper.tipBodyFont, "[BETA]" + this.label, this.x, this.y, Settings.GOLD_COLOR);
                        break;
                    }
                    FontHelper.renderFontCentered(sb, FontHelper.tipBodyFont, "[BETA]" + this.label, this.x, this.y, Settings.BLUE_TEXT_COLOR);
                    break;
                }
                if (this.hb.hovered) {
                    FontHelper.renderFontCentered(sb, FontHelper.tipBodyFont, this.label, this.x, this.y, Settings.GOLD_COLOR);
                    break;
                }
                FontHelper.renderFontCentered(sb, FontHelper.tipBodyFont, this.label, this.x, this.y, Settings.BLUE_TEXT_COLOR);
                break;
            }
            default: {
                FontHelper.renderSmartText(sb, FontHelper.tipBodyFont, "<NOT IMPLEMENTED>", this.x - 60.0f * Settings.scale, this.y, 9999.0f, 0.0f, Settings.BLUE_TEXT_COLOR);
            }
        }
        this.hb.render(sb);
    }

    public void setFullscreen(boolean borderless) {
        TMP_WIDTH = Gdx.graphics.getDisplayMode().width;
        TMP_HEIGHT = Gdx.graphics.getDisplayMode().height;
        OptionsPanel.writeDisplayConfigFile(TMP_WIDTH, TMP_HEIGHT, Settings.MAX_FPS, borderless, borderless, Settings.IS_V_SYNC);
        Settings.SAVED_WIDTH = TMP_WIDTH;
        Settings.SAVED_HEIGHT = TMP_HEIGHT;
        this.index = 0;
        for (int i = 0; i < Settings.displayOptions.size(); ++i) {
            if (!Settings.displayOptions.get(i).equals(new DisplayOption(TMP_WIDTH, TMP_HEIGHT))) continue;
            this.index = i + 1;
        }
        this.label = Integer.toString(TMP_WIDTH) + " x " + Integer.toString(TMP_HEIGHT);
    }

    public static enum DropdownType {
        RESOLUTION,
        FPS,
        LANGUAGE;

    }
}

